local super = require "NumberFormatter"

ScientificFormatter = super:new()

local defaults = {
    decimals = 2,
}

local nilDefaults = {
}

function ScientificFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function ScientificFormatter:getFormatter()
    return NumberStringFormatter:scientific()
end

function ScientificFormatter:getArguments()
    return {
        self:getProperty('decimals'),
    }
end

function ScientificFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    list:add(inspector)
    return list
end

return ScientificFormatter
